<?php

/**
 * This is the model class for table "Tura".
 *
 * The followings are the available columns in table 'Tura':
 * @property double $id
 * @property double $idKlasy
 * @property string $czasRozpoczecia
 * @property string $czasZakonczenia
 * @property string $temat
 * @property string $scenariusz
 */
class Tura extends CActiveRecord
{
	public $nazwaSzkoly;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Tura the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Tura';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idKlasy', 'required'),
			array('idKlasy', 'numerical'),
//			array('temat', 'length', 'max'=>60),
//			array('scenariusz', 'length', 'max'=>500),
			array('czasRozpoczecia, czasZakonczenia', 'safe'),

			array('id, idKlasy, idLekcji, czasRozpoczecia, czasZakonczenia, temat, scenariusz, nazwaSzkoly', 'safe', 'on'=>'search'),
			array('idLekcji', 'safe', 'on'=>'insert'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idKlasy0'=>array(self::BELONGS_TO, 'Klasa', 'idKlasy'),
			'lekcja'=>array(self::BELONGS_TO, 'Lekcja', 'idLekcji'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Tura', 'id'),
			'idKlasy'=>Yii::t('Tura', 'idKlasy'),
			'idLekcji'=>Yii::t('Tura', 'idLekcji'),
			'nazwaSzkoly'=>Yii::t('Tura', 'nazwaSzkoly'),
			'czasRozpoczecia'=>Yii::t('Tura', 'czasRozpoczecia'),
			'czasZakonczenia'=>Yii::t('Tura', 'czasZakonczenia'),
			'temat'=>Yii::t('Tura', 'temat'),
			'scenariusz'=>Yii::t('Tura', 'scenariusz'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;
		
		$classes = Yii::app()->user->getState('classes');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($classes))
			$criteria->addInCondition(Yii::app()->db->quoteTableName("t").'.'.Yii::app()->db->quoteColumnName("idKlasy"), Yii::app()->user->getState('classes'));
		elseif(Yii::app()->user->role == 'schoolAdmin' && empty($classes))
			return new CActiveDataProvider($this, array('data'=>array()));

		$criteria->compare(Yii::app()->db->quoteColumnName('t.id'), $this->id);
		$criteria->compare('LOWER("idKlasy0"."nazwa")', strtolower($this->idKlasy), true);
		$criteria->compare('"lekcja"."id"', $this->idLekcji, true);
		$criteria->compare('"idKlasy0"."szkola"."nazwa"', $this->nazwaSzkoly, true);
		$criteria->compare(Yii::app()->db->quoteColumnName('t.czasRozpoczecia'), $this->czasRozpoczecia, true);
		$criteria->compare(Yii::app()->db->quoteColumnName('t.czasZakonczenia'), $this->czasZakonczenia, true);
//		$criteria->compare('temat', $this->temat, true);
//		$criteria->compare('scenariusz', $this->scenariusz, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Rozpoczyna nową turę - wstawia do tabeli "Tura" nowy wiersz
	 * @param type $duration - czas trwania tury w minutach
	 */
	public function startNewRound($duration, $lessonId, $classId)
	{
		$sql = 'INSERT INTO "Tura"
			( "idKlasy", "czasRozpoczecia", "czasZakonczenia", "idLekcji" )
			VALUES
			( '.$classId.', SYSDATE, SYSDATE + '.$duration.'/1440, '.$lessonId.')';

		Yii::app()->db->createCommand($sql)->execute();
	}

	public function getIsActive()
	{
		return empty($this->czasZakonczenia) || strtotime($this->czasZakonczenia) > time();
	}

	/**
	 * @param int $classId
	 * @return Tura
	 */
	public static function getTuraForClass($classId)
	{
		return  Tura::model()->findBySql('
			select * from "Tura"
			where "idKlasy" = :idKlasy and ROWNUM <= 1
			order by "czasRozpoczecia" desc
		', array(':idKlasy' => $classId));
	}

	/**
	 * @param int $companyId
	 * @return Tura
	 */
	public static function getTuraByCompany($companyId)
	{
		return Tura::model()->findBySql('select * from "Tura" where "idKlasy" = (
			select "idKlasy" from "Firma" where "id" = :companyId) and ROWNUM <= 1
			order by "czasRozpoczecia" desc
		', array(':companyId' => $companyId));
	}
	
	public function checkIfCancelAllowed()
	{
		$currentDate = Yii::app()->db->createCommand('SELECT SYSDATE FROM DUAL')->queryScalar();
		$currentSeconds = strtotime($currentDate); 
		
		$turaStartTimeSeconds = strtotime($this->czasRozpoczecia); 
		
		//roznica 10 minut
		$cancelAllowed = $currentSeconds < $turaStartTimeSeconds + 600;// 600s=10min

		//sprawdzenie, czy jakis uzytkownik sie zalogowal
		$lastLoginDateFromDb = Yii::app()->db->createCommand('SELECT "dataLogowania" FROM "Uzytkownik" WHERE "idKlasy" = :classId ORDER BY "dataLogowania" DESC')->queryScalar(array(':classId'=>$this->idKlasy));

		if($lastLoginDateFromDb !== false && $lastLoginDateFromDb !== null)
		{
			//modyfikacje na $lastLoginDate, bo strtotime($lastLoginDate) zwraca false
			//i trzeba to przekonwertowac na inny format
			//aktualny format: 15/07/12 15:13:26
			//prawidlowy dla strtotime format: 12-07-2015 15:39:59
			$date = DateTime::createFromFormat('y/m/d H:i:s', $lastLoginDateFromDb);
			$lastLoginDate = $date->format('d-m-Y H:i:s');
			
			$lastLoginDateSeconds = strtotime($lastLoginDate);

			$cancelAllowed = $cancelAllowed && ($lastLoginDateSeconds < $turaStartTimeSeconds);
		}
		return $cancelAllowed;
	}
}
